Attribute VB_Name = "Garmin"
'
' GPSTest Makro
' Copyright 2004 by Steffen Kirbach
'

' Import from GarminGPS.inc

Const Wpt = 1
Const Rte = 2
Const Trk = 4
Const Prx = 8
Const Alm = 16
Const All = 31
Const UnknownValue As Single = 1E+25
Const TrkTime_0 = 32873

Type TPosn
  Lat As Double
  Lon As Double
End Type

Type TProtocol
  L0 As Integer
  A0 As Integer
  A1_A As Integer
  A1_D As Integer
  A2_A As Integer
  A2_Hdr As Integer
  A2_Wpt As Integer
  A2_Lnk As Integer
  A3_A As Integer
  A3_Hdr As Integer
  A3_Trk As Integer
  A4_A As Integer
  A4_D As Integer
  A5_A As Integer
  A5_D As Integer
  A6_A As Integer
  A6_D As Integer
  A7_A As Integer
  A7_D As Integer
  A8_A As Integer
  A8_D As Integer
End Type

' Import from GarminDll.inc

Const idEmty = 0
Const idWpt = 1
Const idRteHdr = 2
Const idRte = 3
Const idRteLnk = 4
Const idTrkHdr = 5
Const idTrk = 6
Const idPrx = 7
Const idAlm = 8

Type TDllInfo                       ' 256 Byte !!!
  Version As String * 64
  Description As String * 64
  Copyright As String * 64
  Comments As String * 64
End Type

Type TGPSInfo                       ' 310 Byte !!!
  ComPort As Long
  ProductID As Long
  SoftwareVersion As Long
  ProductDescription As String * 256
  Protocol As TProtocol
End Type

Type TWptRec                        ' 544 Byte !!!
  ID As Long
  WptIdent As String * 256
  WptCmnt As String * 256
  WptPosn As TPosn
  WptAlt As Single
  WptDist As Single
  WptSymbolID As Long
End Type

Type TRteHdrRec                     ' 544 Byte !!!
  ID As Long
  RteHdrIdent As String * 256
  RteHdrCmnt As String * 256
  dummy As String * 28
End Type

Type TTrkHdrRec                     ' 544 Byte !!!
  ID As Long
  TrkHdrIdent As String * 256
  dummy As String * 284
End Type

Type TTrkRec                        ' 544 Byte !!!
  ID As Long
  TrkPosn As TPosn
  TrkAlt As Single
  TrkTime As Date
  TrkNew As Boolean
  dummy As String * 510
End Type

Private Declare Sub GetDllInfo Lib "Garmin" (Info As TDllInfo)

Private Declare Function DegToLatStr Lib "Garmin" (ByVal LatDeg As Double, ByVal LonStr As String, ByVal MaxLen As Long) As Boolean
Private Declare Function DegToLonStr Lib "Garmin" (ByVal LonDeg As Double, ByVal LonStr As String, ByVal MaxLen As Long) As Boolean
Private Declare Function LatStrToDeg Lib "Garmin" (ByVal LatStr As String, LatDeg As Double) As Boolean
Private Declare Function LonStrToDeg Lib "Garmin" (ByVal LonStr As String, LonDeg As Double) As Boolean

Private Declare Function GetSubString Lib "Garmin" (ByVal Str As String, ByVal Pos As Long, ByVal SubStr As String, ByVal MaxLen As Long) As Boolean

Private Declare Function IconNrToGarminSymbol Lib "Garmin" (ByVal IconNo As Long, ByVal DataTyp As Long) As Long
Private Declare Function GarminSymbolToIconNo Lib "Garmin" (ByVal SymbolID As Long, ByVal DataTyp As Long) As Long

Private Declare Sub SetFmtStrings Lib "Garmin" (ByVal LatFmt As String, ByVal LonFmt As String)

Private Declare Sub SetComPort Lib "Garmin" (ByVal ComPort As Long, ByVal AutoDetect As Boolean)
Private Declare Sub SetDefaultProtocol Lib "Garmin" (ByVal Protocol As TProtocol)

Private Declare Sub GetLastErrorStr Lib "Garmin" (ByVal ErrorStr As String, ByVal MaxLen As Long)

Private Declare Function ReadInfo Lib "Garmin" (Info As TGPSInfo) As Boolean
Private Declare Function ReadDateTime Lib "Garmin" (DateTime As Date) As Boolean
Private Declare Function ReadPosition Lib "Garmin" (Posn As TPosn) As Boolean
Private Declare Function ReadVoltage Lib "Garmin" (Intern As Long, Extern As Long) As Boolean
Private Declare Function PowerOFF Lib "Garmin" () As Boolean

Private Declare Function ReadData Lib "Garmin" (ByVal ID As Byte, ByVal FName As String) As Boolean
Private Declare Function WriteData Lib "Garmin" (ByVal ID As Byte, ByVal FName As String) As Boolean

Private Declare Function ReadBufferWpt Lib "Garmin" Alias "ReadBuffer" (ByVal BufPos As Long, DataRec As TWptRec) As Boolean
Private Declare Function ReadBufferRteHdr Lib "Garmin" Alias "ReadBuffer" (ByVal BufPos As Long, DataRec As TRteHdrRec) As Boolean
Private Declare Function ReadBufferTrkHdr Lib "Garmin" Alias "ReadBuffer" (ByVal BufPos As Long, DataRec As TTrkHdrRec) As Boolean
Private Declare Function ReadBufferTrk Lib "Garmin" Alias "ReadBuffer" (ByVal BufPos As Long, DataRec As TTrkRec) As Boolean

Private Declare Function WriteBufferWpt Lib "Garmin" Alias "WriteBuffer" (DataRec As TWptRec) As Boolean
Private Declare Function WriteBufferRteHdr Lib "Garmin" Alias "WriteBuffer" (DataRec As TRteHdrRec) As Boolean
Private Declare Function WriteBufferTrkHdr Lib "Garmin" Alias "WriteBuffer" (DataRec As TTrkHdrRec) As Boolean
Private Declare Function WriteBufferTrk Lib "Garmin" Alias "WriteBuffer" (DataRec As TTrkRec) As Boolean

Private Declare Sub ClearBuffer Lib "Garmin" ()

Private Declare Function Backup Lib "Garmin" (FName As String) As Boolean
Private Declare Function Restore Lib "Garmin" (FName As String) As Boolean

'
Private Function ConvStr(TermStr) As String
  ConvStr = Left(TermStr, InStr(1, TermStr, Chr(0)) - 1)
End Function

'
Private Sub Display(ItemName, ItemText, Texture)
  Tabs = 5 - (Len(ItemName) \ 6)
  ActiveDocument.Paragraphs.Last.Shading.Texture = Texture
  Call ActiveDocument.Content.InsertAfter(ItemName & String(Tabs, vbTab) & ItemText & vbCrLf)
End Sub

' format error string
Private Function ErrorMsg() As String
  Dim ErrStr As String
  ErrStr = String(256, 0)
  Call GetLastErrorStr(ErrStr, 256)
  ErrorMsg = ConvStr(ErrStr)
End Function

' display DLL info
Private Sub DllInfo()
  Dim Info As TDllInfo
  Call GetDllInfo(Info)
  Call Display("Dll Information", "", wdTexture15Percent)
  Call Display("Version", ConvStr(Info.Version), wdTexture5Percent)
  Call Display("Description", ConvStr(Info.Description), wdTexture5Percent)
  Call Display("Copyright", ConvStr(Info.Copyright), wdTexture5Percent)
  Call Display("Comments", ConvStr(Info.Comments), wdTexture5Percent)
  Call Display("", "", wdTextureNone)
End Sub

' display GPS info
Private Sub GPSInfo()
  Dim Info As TGPSInfo
  Dim SubStr As String * 255
  Dim i As Integer
  If ReadInfo(Info) Then
    Call Display("GPS Information", "", wdTexture15Percent)
    Call Display("Serial Port", "COM" & Info.ComPort, wdTexture5Percent)
    Call Display("Product ID", Info.ProductID, wdTexture5Percent)
    Call Display("Software Version", Info.SoftwareVersion, wdTexture5Percent)
    Call Display("Description", ConvStr(Info.ProductDescription), wdTexture5Percent)
    i = 1
    While GetSubString(Info.ProductDescription, i, SubStr, 255)
      Call Display("", ConvStr(SubStr), wdTexture5Percent)
      i = i + 1
    Wend
    Call Display("", "", wdTextureNone)
  Else
    MsgBox ErrorMsg
    End
  End If
End Sub

' display GPS voltage
Private Sub GPSVoltage()
  If ReadVoltage(Intern, Extern) Then
    Call Display("GPS Voltage", Intern / 100 & "V intern / " & Extern / 100 & "V extern", wdTexture5Percent)
  Else
    Call Display("GPS Voltage", ErrorMsg, wdTexture5Percent)
  End If
  Call Display("", "", wdTextureNone)
End Sub

' display GPS time
Private Sub GPSDateTime()
  Dim DateTime
  If ReadDateTime(DateTime) Then
    Call Display("GPS Time (UTC)", DateTime, wdTexture5Percent)
    Call Display("", "", wdTextureNone)
  Else
    MsgBox ErrorMsg
  End If
End Sub

' display GPS position
Private Sub GPSPosition()
  Dim Posn As TPosn
  Dim LatStr As String * 16
  Dim LonStr As String * 16
  If ReadPosition(Posn) Then
    If (DegToLatStr(Posn.Lat, LatStr, 16) And DegToLonStr(Posn.Lon, LonStr, 16)) Then
      Call Display("GPS Position", ConvStr(LatStr) & "   " & ConvStr(LonStr), wdTexture5Percent)
    Else
      Call Display("GPS Position", ErrorMsg, wdTexture5Percent)
    End If
    Call Display("", "", wdTextureNone)
  Else
    MsgBox ErrorMsg
  End If
End Sub

' display waypoints
Private Sub GPSReadWpt()
  Dim Data As TWptRec
  Dim LatStr As String * 16
  Dim LonStr As String * 16
  Dim i As Long
  If ReadData(Wpt, "") Then
    Call Display("Waypoint", "", wdTexture15Percent)
    i = 0
    While ReadBufferWpt(i, Data)
      If Data.ID = idWpt Then
        If (DegToLatStr(Data.WptPosn.Lat, LatStr, 16) And DegToLonStr(Data.WptPosn.Lon, LonStr, 16)) Then
          Call Display(ConvStr(Data.WptIdent), ConvStr(LatStr) & "   " & ConvStr(LonStr), wdTexture5Percent)
        Else
          Call Display(ConvStr(Data.WptIdent), ErrorMsg, wdTexture5Percent)
        End If
      End If
      i = i + 1
    Wend
    Call Display("", "", wdTextureNone)
  Else
    MsgBox ErrorMsg
  End If
End Sub

' display routes
Private Sub GPSReadRte()
  Dim Hdr As TRteHdrRec
  Dim Data As TWptRec
  Dim LatStr As String * 16
  Dim LonStr As String * 16
  Dim i As Long
  If ReadData(Rte, "") Then
    Call Display("Route", "", wdTexture15Percent)
    i = 0
    While ReadBufferWpt(i, Data)
      If Data.ID = idRte Then
        If (DegToLatStr(Data.WptPosn.Lat, LatStr, 16) And DegToLonStr(Data.WptPosn.Lon, LonStr, 16)) Then
          Call Display(ConvStr(Data.WptIdent), ConvStr(LatStr) & "   " & ConvStr(LonStr), wdTexture5Percent)
        Else
          Call Display(ConvStr(Data.WptIdent), ErrorMsg, wdTexture5Percent)
        End If
      End If
      If Data.ID = idRteHdr Then
        Call ReadBufferRteHdr(i, Hdr)
        Call Display(ConvStr(Hdr.RteHdrIdent), ConvStr(Hdr.RteHdrCmnt), wdTexture10Percent)
      End If
      i = i + 1
    Wend
    Call Display("", "", wdTextureNone)
  Else
    MsgBox ErrorMsg
  End If
End Sub

' display tracks
Private Sub GPSReadTrk()
  Dim Hdr As TTrkHdrRec
  Dim Data As TTrkRec
  Dim LatStr As String * 16
  Dim LonStr As String * 16
  Dim i As Long
  If ReadData(Trk, "") Then
    Call Display("Track", "", wdTexture15Percent)
    i = 0
    While ReadBufferTrk(i, Data)
      If Data.ID = idTrkHdr Then
        Call ReadBufferTrkHdr(i, Hdr)
        Call Display(ConvStr(Hdr.TrkHdrIdent), "", wdTexture10Percent)
      End If
      If Data.ID = idTrk Then
        If (DegToLatStr(Data.TrkPosn.Lat, LatStr, 16) And DegToLonStr(Data.TrkPosn.Lon, LonStr, 16)) Then
          If Data.TrkNew Then
            N = "New  "
          Else
            N = "     "
          End If
          If Data.TrkTime < TrkTime_0 Then
            Call Display(N, ConvStr(LatStr) & "   " & ConvStr(LonStr), wdTexture5Percent)
          Else
            Call Display(N & Data.TrkTime, ConvStr(LatStr) & "   " & ConvStr(LonStr), wdTexture5Percent)
          End If
        Else
          Call Display(N, ErrorMsg, wdTexture5Percent)
        End If
      End If
      i = i + 1
    Wend
    Call Display("", "", wdTextureNone)
  Else
    MsgBox ErrorMsg
  End If
End Sub

' read from GPS
Sub GPSReadSample()
  With Documents.Add.Content
    .Font.Name = "Courier New"
    .Font.Size = "10"
  End With
    
  Call DllInfo
  Call GPSInfo
  Call GPSVoltage
  Call GPSDateTime
  Call GPSPosition
  Call GPSReadWpt
  Call GPSReadRte
  Call GPSReadTrk
  Call PowerOFF
  
  ActiveDocument.SpellingChecked = True
End Sub

' write to GPS
Sub GPSWriteSample()
  Dim WptRec As TWptRec
  Dim RteHdrRec As TRteHdrRec
  Dim TrkHdrRec As TTrkHdrRec
  Dim TrkRec As TTrkRec
  Dim Lat As Double
  Dim Lon As Double
    
  ClearBuffer

  If Not LatStrToDeg("S45,03230", Lat) Then
    MsgBox ErrorMsg
    Exit Sub
  End If
  If Not LonStrToDeg("E168,66608", Lon) Then
    MsgBox ErrorMsg
    Exit Sub
  End If
  
  ' send a waypoint
  WptRec.ID = idWpt
  WptRec.WptIdent = "Queenstown"
  WptRec.WptCmnt = "Australia"
  WptRec.WptPosn.Lat = Lat
  WptRec.WptPosn.Lon = Lon
  WptRec.WptAlt = 350
  WptRec.WptDist = 100
  WptRec.WptSymbolID = GarminSymbolToIconNo(8199, 109)     'sym_med_cty & D109
  Call WriteBufferWpt(WptRec)
  
  ' send a route with 4 same waypoints
  RteHdrRec.ID = idRteHdr
  RteHdrRec.RteHdrIdent = "Route 1"
  Call WriteBufferRteHdr(RteHdrRec)
  WptRec.ID = idRte
  Call WriteBufferWpt(WptRec)
  Call WriteBufferWpt(WptRec)
  Call WriteBufferWpt(WptRec)
  Call WriteBufferWpt(WptRec)
  
  ' send a track with 4 same trackpoints
  TrkHdrRec.ID = idTrkHdr
  TrkHdrRec.TrkHdrIdent = "Track 1"
  Call WriteBufferTrkHdr(TrkHdrRec)
  TrkRec.ID = idTrk
  TrkRec.TrkPosn.Lat = Lat
  TrkRec.TrkPosn.Lon = Lon
  TrkRec.TrkTime = Now
  TrkRec.TrkAlt = 350
  Call WriteBufferTrk(TrkRec)
  Call WriteBufferTrk(TrkRec)
  Call WriteBufferTrk(TrkRec)
  Call WriteBufferTrk(TrkRec)
  
  ' send do GPS ("") or File ("FName")
  If Not WriteData(Wpt + Rte + Trk, "") Then
    MsgBox ErrorMsg
  End If
End Sub
