{ Copyright 2002 by Steffen Kirbach }
{ http://www.sksoft.de              }
{ Freeware                          }

unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls;

{$I ..\GarminGPS.inc}
{$I ..\GarminDLL.inc}

type
  TMainForm = class(TForm)
    SaveDialog: TSaveDialog;
    OpenDialog: TOpenDialog;
    Liste: TListView;
    Panel1: TPanel;
    Label1: TLabel;
    BackupBtn: TButton;
    RestoreBtn: TButton;
    ReadWptBtn: TButton;
    ReadRteBtn: TButton;
    ReadTrkBtn: TButton;
    ReadPrxBtn: TButton;
    FormatBox: TComboBox;
    InfoPanel: TPanel;
    ModelLabel: TLabel;
    DescriptionLabel: TLabel;
    ProtocolLabel: TLabel;
    ReadFileBtn: TButton;
    WriteGRMBtn: TButton;
    ShutOffBtn: TButton;
    IDBtn: TButton;
    TimeBtn: TButton;
    PositionBtn: TButton;
    SymbolList: TImageList;
    InfoBtn: TButton;
    VoltageBtn: TButton;
    WriteWptBtn: TButton;
    WriteRteBtn: TButton;
    procedure BackupBtnClick(Sender: TObject);
    procedure RestoreBtnClick(Sender: TObject);
    procedure ReadWptBtnClick(Sender: TObject);
    procedure ReadRteBtnClick(Sender: TObject);
    procedure ReadTrkBtnClick(Sender: TObject);
    procedure ReadPrxBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ReadFileBtnClick(Sender: TObject);
    procedure ShutOffBtnClick(Sender: TObject);
    procedure IDBtnClick(Sender: TObject);
    procedure WriteGRMBtnClick(Sender: TObject);
    procedure PositionBtnClick(Sender: TObject);
    procedure TimeBtnClick(Sender: TObject);
    procedure ListeDeletion(Sender: TObject; Item: TListItem);
    procedure FormatBoxChange(Sender: TObject);
    procedure InfoBtnClick(Sender: TObject);
    procedure VoltageBtnClick(Sender: TObject);
    procedure WriteWptBtnClick(Sender: TObject);
    procedure WriteRteBtnClick(Sender: TObject);
  private
    GPSInfo: TGPSInfo;
    procedure Error;
  public
    { Public-Deklarationen }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

const
  NewTrk = '  (New)';

type
  TItemInfo  = record
                 RecID: Integer;
                 Saved: Boolean;
               end;
  TPItemInfo = ^TItemInfo;

{******************************************************************************}

procedure TMainForm.Error;
var
  S: Array[0..255] of Char;
begin
  DescriptionLabel.Caption:= '';
  ModelLabel.Caption:= '';
  ProtocolLabel.Caption:= '';
  GetLastErrorStr(S, SizeOf(S));
  MessageBox(0, S, nil, MB_APPLMODAL + MB_ICONERROR)
end;

{******************************************************************************}

procedure TMainForm.FormCreate(Sender: TObject);
var
  DllInfo: TDllInfo;
begin
  FormatBox.ItemIndex:= 1;
  SymbolList.Clear;
  with TBitmap.Create do
  try
    LoadFromResourceName(GetDllInstance, SymbolResourceName);
    SymbolList.ResInstLoad(GetDllInstance, rtBitmap,
                           SymbolResourceName, TransparentColor);
  finally
    Free;
  end;
  GetDllInfo(DllInfo);
end;

{******************************************************************************}

procedure TMainForm.BackupBtnClick(Sender: TObject);
begin
  if SaveDialog.Execute then
    if not Backup(PChar(SaveDialog.FileName)) then Error;
end;

procedure TMainForm.RestoreBtnClick(Sender: TObject);
begin
  if OpenDialog.Execute then
    if not Restore(PChar(OpenDialog.FileName)) then Error;
end;

{******************************************************************************}

procedure InfoCBProc(Info: TGPSInfo); stdcall;
begin
  with MainForm, Info do
  begin
    GPSInfo:= Info;
    ModelLabel.Caption:= Format('Model %d', [ID]);
    DescriptionLabel.Caption:= Format('%s', [Description]);
    ProtocolLabel.Caption:=
      Format('L%.3d; A%.3d; A%.3d (D%.3d); A%.3d (D%.3d, D%.3d, D%.3d)'^M +
             'A%.3d (D%.3d, D%.3d); A%.3d (D%.3d); A%.3d (D%.3d)'^M +
             'A%.3d (D%.3d); A%.3d (D%.3d); A%.3d (D%.3d)',
             [Protocol.L0, Protocol.A0,
              Protocol.A1.A, Protocol.A1.D,
              Protocol.A2.A, Protocol.A2.Hdr, Protocol.A2.Wpt, Protocol.A2.Lnk,
              Protocol.A3.A, Protocol.A3.Hdr, Protocol.A3.Trk,
              Protocol.A4.A, Protocol.A4.D,
              Protocol.A5.A, Protocol.A5.D,
              Protocol.A6.A, Protocol.A6.D,
              Protocol.A7.A, Protocol.A7.D,
              Protocol.A8.A, Protocol.A8.D]);
  end;
end;

{******************************************************************************}

procedure DisplayCBProc(CBRec: TSimpleRec; DataRec: PDataRec); stdcall;
var
  ItemInfo: TPItemInfo;
  C: TPosnStr;
begin
  if CBRec.ID = idWpt then MainForm.WriteWptBtn.Enabled:= True;
  if CBRec.ID = idRte then MainForm.WriteRteBtn.Enabled:= True;
  case CBRec.ID of
    idWpt, idRte, idPrx:
      if DegToStr(CBRec.WptPosn, C) then
        with MainForm.Liste.Items.Add, CBRec do
        begin
          New(ItemInfo);
          ItemInfo.RecID:= ID;
          ItemInfo.Saved:= False;
          Data:= ItemInfo;
          Caption:= WptIdent;
          SubItems.Append(WptCmnt);
          SubItems.Append(C.Lat);
          SubItems.Append(C.Lon);
          if WptAlt <> UnknownValue then SubItems.Append(IntToStr(Round(WptAlt)))
          else SubItems.Append('');
          if WptDist <> UnknownValue then SubItems.Append(IntToStr(Round(WptDist)))
          else SubItems.Append('');
          SubItems.Append(IntToStr(Ord(TPItemInfo(Data).RecID)));
          ImageIndex:= WptSymbol;
        end
      else MainForm.Error;
    idRteHdr:
      begin
        with MainForm.Liste.Items.Add, CBRec do
        begin
          New(ItemInfo);
          ItemInfo.RecID:= ID;
          Data:= ItemInfo;
          Caption:= RteHdrIdent;
          SubItems.Append(RteHdrCmnt);
          SubItems.Append('');
          SubItems.Append('');
          SubItems.Append('');
          SubItems.Append('');
          SubItems.Append(IntToStr(Ord(TPItemInfo(Data).RecID)));
          ImageIndex:= -1;
        end;
      end;
    idTrkHdr:
    begin
      with MainForm.Liste.Items.Add, CBRec do
      begin
        New(ItemInfo);
        ItemInfo.RecID:= ID;
        Data:= ItemInfo;
        Caption:= TrkHdrIdent;
        SubItems.Append('');
        SubItems.Append('');
        SubItems.Append('');
        SubItems.Append('');
        SubItems.Append('');
        SubItems.Append(IntToStr(Ord(TPItemInfo(Data).RecID)));
        ImageIndex:= -1;
      end;
    end;
    idTrk:
      if DegToStr(CBRec.TrkPosn, C) then
        with MainForm.Liste.Items.Add, CBRec do
        begin
          New(ItemInfo);
          ItemInfo.RecID:= ID;
          Data:= ItemInfo;
          if TrkNew then Caption:= Format('%.4d%s', [Index, NewTrk])
          else Caption:= Format('%.4d', [Index]);
          if TrkTime = 0 then SubItems.Append('')
          else SubItems.Append(DateTimeToStr(TrkTime));
          SubItems.Append(C.Lat);
          SubItems.Append(C.Lon);
          if TrkAlt <> UnknownValue then SubItems.Append(IntToStr(Round(TrkAlt)))
          else SubItems.Append('');
          SubItems.Append('');
          SubItems.Append(IntToStr(Ord(TPItemInfo(Data).RecID)));
          ImageIndex:= -1;
        end
      else MainForm.Error;
  end;
end;

{******************************************************************************}

function WriteCBProc(var CBRec: TSimpleRec; DataRec: PDataRec): Bool; stdcall;
var
  PosnStr: TPosnStr;
  i: Integer;

  procedure Waypoint;
  begin
    with MainForm.Liste.Items[i], CBRec do
    begin
      StrPLCopy(WptIdent, Caption, 255);
      WptSymbol:= ImageIndex;
      StrPLCopy(WptCmnt, SubItems[0], 255);
      StrPLCopy(PosnStr.Lat, SubItems[1], SizeOf(PosnStr.Lat) - 1);
      StrPLCopy(PosnStr.Lon, SubItems[2], SizeOf(PosnStr.Lon) - 1);
      if not StrToDeg(PosnStr, CBRec.WptPosn) then MainForm.Error;
      if Length(SubItems[3]) > 0 then WptAlt:= StrToFloat(SubItems[3]);
      if Length(SubItems[4]) > 0 then WptDist:= StrToFloat(SubItems[4]);
    end;
  end;

begin
  Result:= False;
  for i:= 0 to MainForm.Liste.Items.Count - 1 do
    with MainForm.Liste.Items[i], CBRec do
    begin
      if not Assigned(Data) then Continue;
      if TPItemInfo(Data).Saved then Continue;
      case ID of
        idWpt:
          if TPItemInfo(Data).RecID <> ID then Continue
          else
          begin
            Waypoint;
            TPItemInfo(Data).Saved:= True;
            Result:= True;
            Break;
          end;
        idRteHdr:
          if TPItemInfo(Data).RecID <> ID then Continue
          else
          begin
            StrPLCopy(RteHdrIdent, Caption, 255);
            StrPLCopy(RteHdrCmnt, SubItems[0], 255);
            TPItemInfo(Data).Saved:= True;
            Result:= True;
            Break;
          end;
        idRte:
          if TPItemInfo(Data).RecID <> ID then Break
          else
          begin
            Waypoint;
            TPItemInfo(Data).Saved:= True;
            Result:= True;
            Break;
          end;
        idRteLnk:
          Result:= True;
        idTrkHdr:
          begin
            if TPItemInfo(Data).RecID = idTrk then
            begin
              TrkHdrIdent:= 'TrkHdr';
              Result:= True;
              Exit;
            end;
            if TPItemInfo(Data).RecID <> ID then Continue
            else
            begin
              StrPLCopy(TrkHdrIdent, Caption, 255);
              TPItemInfo(Data).Saved:= True;
              Result:= True;
              Break;
            end;
          end;
        idTrk:
          begin
            if (TPItemInfo(Data).RecID = idTrkHdr) and
               (MainForm.GPSInfo.Protocol.A3.Hdr <> 0) then Exit;
            if TPItemInfo(Data).RecID <> ID then Continue
            else
            begin
              TrkNew:= Pos(NewTrk, Caption) <> 0;
              TrkTime:= DateTimeToTrkTime(StrToDateTime(SubItems[0]));
              StrPLCopy(PosnStr.Lat, SubItems[1], SizeOf(PosnStr.Lat) - 1);
              StrPLCopy(PosnStr.Lon, SubItems[2], SizeOf(PosnStr.Lon) - 1);
              StrToDeg(PosnStr, TrkPosn);
              if Length(SubItems[3]) > 0 then TrkAlt:= StrToFloat(SubItems[3]);
              TPItemInfo(Data).Saved:= True;
              Result:= True;
              Break;
            end;
          end;
        idPrx:
          if TPItemInfo(Data).RecID <> ID then Continue
          else
          begin
            Waypoint;
            TPItemInfo(Data).Saved:= True;
            Result:= True;
            Break;
          end;
      end;
    end;
end;

{******************************************************************************}

procedure TMainForm.ReadWptBtnClick(Sender: TObject);
begin
  WriteWptBtn.Enabled:= False;
  WriteRteBtn.Enabled:= False;
  Liste.Items.BeginUpdate;
  try
    Liste.Items.Clear;
    if not ReadData(Wpt, nil) then Error;
  finally
    Liste.Items.EndUpdate;
  end;
end;

procedure TMainForm.WriteWptBtnClick(Sender: TObject);
var
  i: Integer;
begin
  for i:= 0 to Liste.Items.Count - 1 do
    with Liste.Items[i] do
      if Assigned(Data) then TPItemInfo(Data).Saved:= False;
  if not WriteData(Wpt, nil) then Error;
end;

procedure TMainForm.ReadRteBtnClick(Sender: TObject);
begin
  WriteWptBtn.Enabled:= False;
  WriteRteBtn.Enabled:= False;
  Liste.Items.BeginUpdate;
  try
    Liste.Items.Clear;
    if not ReadData(Rte, nil) then Error;
  finally
    Liste.Items.EndUpdate;
  end;
end;

procedure TMainForm.WriteRteBtnClick(Sender: TObject);
var
  i: Integer;
begin
  for i:= 0 to Liste.Items.Count - 1 do
    with Liste.Items[i] do
      if Assigned(Data) then TPItemInfo(Data).Saved:= False;
  if not WriteData(Rte, nil) then Error;
end;

procedure TMainForm.ReadTrkBtnClick(Sender: TObject);
begin
  WriteWptBtn.Enabled:= False;
  WriteRteBtn.Enabled:= False;
  Liste.Items.BeginUpdate;
  try
    Liste.Items.Clear;
    if not ReadData(Trk, nil) then Error;
  finally
    Liste.Items.EndUpdate;
  end;
end;

procedure TMainForm.ReadPrxBtnClick(Sender: TObject);
begin
  WriteWptBtn.Enabled:= False;
  WriteRteBtn.Enabled:= False;
  Liste.Items.BeginUpdate;
  try
    Liste.Items.Clear;
    if not ReadData(Prx, nil) then Error;
  finally
    Liste.Items.EndUpdate;
  end;
end;

{******************************************************************************}

procedure TMainForm.ShutOffBtnClick(Sender: TObject);
begin
  if not PowerOFF then Error;
end;

procedure TMainForm.IDBtnClick(Sender: TObject);
var
  ID1: DWord;
  ID2: TLargeInteger;
begin
  if ReadUnitID(ID1) then
  begin
    ID2.HighPart:= 0;
    ID2.LowPart:= ID1;
    ShowMessage(FloatToStr(ID2.QuadPart));
  end;
end;

procedure TMainForm.InfoBtnClick(Sender: TObject);
var
  GPSInfoRec: TGPSInfo;
  S: String;
  i: Integer;
  X: Array[0..255] of Char;
begin
  if ReadInfo(GPSInfoRec) then
  begin
    S:= '';
    i:= 0;
    while GetSubString(GPSInfoRec.Description, i, X, SizeOf(X)) do
    begin
      S:= S + X + #10#13;
      Inc(i);
    end;
    ShowMessage(S);
  end
  else Error;
end;

procedure TMainForm.VoltageBtnClick(Sender: TObject);
var
  Intern, Extern: Integer;
begin
  if ReadVoltage(Intern, Extern) then
    ShowMessageFmt('intern: %f V / extern: %f V', [Intern / 100, Extern / 100])
  else Error;
end;

procedure TMainForm.PositionBtnClick(Sender: TObject);
var
  P: TPosn;
  C: TPosnStr;
begin
  if ReadPosition(P) then
  begin
    if DegToStr(P, C) then ShowMessage(Format('%s  %s', [C.Lat, C.Lon]))
  end
  else Error;
end;

procedure TMainForm.TimeBtnClick(Sender: TObject);
var
  DT: TDateTime;
begin
  if ReadDateTime(DT) then ShowMessage(DateTimeToStr(DT)+ ' (GMT)')
  else Error;
end;

{******************************************************************************}

procedure TMainForm.ReadFileBtnClick(Sender: TObject);
begin
  WriteWptBtn.Enabled:= False;
  WriteRteBtn.Enabled:= False;
  Liste.Items.BeginUpdate;
  try
    Liste.Items.Clear;
    if OpenDialog.Execute then
    try
      Screen.Cursor:= crHourGlass;
      if not ReadData(All, PChar(OpenDialog.FileName)) then Error;
    finally
      Screen.Cursor:= crDefault;
    end;
  finally
    Liste.Items.EndUpdate;
  end;
end;

procedure TMainForm.WriteGRMBtnClick(Sender: TObject);
var
  i: Integer;
begin
  for i:= 0 to MainForm.Liste.Items.Count - 1 do
    with MainForm.Liste.Items[i] do
      if Assigned(Data) then TPItemInfo(Data).Saved:= False;
  if OpenDialog.Execute then
  try
    Screen.Cursor:= crHourGlass;
    if not WriteData(All, PChar(OpenDialog.FileName)) then Error;
  finally
    Screen.Cursor:= crDefault;
  end;
end;

{******************************************************************************}

procedure TMainForm.ListeDeletion(Sender: TObject; Item: TListItem);
begin
  Dispose(Item.Data);
end;

procedure TMainForm.FormatBoxChange(Sender: TObject);
begin
  case TComboBox(Sender).ItemIndex of
    0: SetFmtStrings('[_+-][G08]', '[_+-][G08]');
    1: SetFmtStrings(LatFmtString1, LonFmtString1);
    2: SetFmtStrings(LatFmtString2, LonFmtString2);
    3: SetFmtStrings(LatFmtString3, LonFmtString3);
    4: SetFmtStrings(LatFmtString4, LonFmtString4);
    5: SetFmtStrings(LatFmtString5, LonFmtString5);
    6: SetFmtStrings(LatFmtString6, LonFmtString6);
    else SetFmtStrings('', '');
  end;
end;

initialization
  SetCallbackPtr(InfoCBProc, DisplayCBProc, WriteCBProc);
end.
