unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, BFH;

type
  TMainForm = class(TForm)
    PwdButton: TButton;
    FEncButton: TButton;
    FDecButton: TButton;
    SEncButton: TButton;
    SDecButton: TButton;
    BFH: TBFH;
    SFNameCheckBox: TCheckBox;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    procedure FormCreate(Sender: TObject);
    procedure SFNameCheckBoxClick(Sender: TObject);
    procedure PwdButtonClick(Sender: TObject);
    procedure FEncButtonClick(Sender: TObject);
    procedure FDecButtonClick(Sender: TObject);
    procedure SEncButtonClick(Sender: TObject);
    procedure SDecButtonClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
begin
  SFNameCheckBox.Checked:= BFH.SecureFileName;
end;

procedure TMainForm.SFNameCheckBoxClick(Sender: TObject);
begin
  BFH.SecureFileName:= (Sender as TCheckBox).Checked;
end;

procedure TMainForm.PwdButtonClick(Sender: TObject);
begin
  BFH.Keyword:= InputBox('BFH Sample', 'Password?', '');
end;

procedure TMainForm.FEncButtonClick(Sender: TObject);
begin
  OpenDialog.Filter:= '*.*|*.*';
  if OpenDialog.Execute then BFH.EncryptFile(OpenDialog.FileName);
end;

procedure TMainForm.FDecButtonClick(Sender: TObject);
begin
  OpenDialog.Filter:= 'BFH|*.BFH';
  if OpenDialog.Execute then BFH.DecryptFile(OpenDialog.FileName);
end;

procedure TMainForm.SEncButtonClick(Sender: TObject);
var
  PStream,
  CStream: TFileStream;
begin
  OpenDialog.Filter:= '*.*|*.*';
  if OpenDialog.Execute then
  begin
    PStream:= TFileStream.Create(OpenDialog.FileName, fmOpenRead);
    try
      SaveDialog.Filter:= 'BFH|*.BFH';
      SaveDialog.DefaultExt:= 'BFH';
      SaveDialog.InitialDir:= ExtractFilePath(OpenDialog.FileName);
      SaveDialog.FileName:= BFH.GetRandomFileName;
      if SaveDialog.Execute then
      begin
        CStream:= TFileStream.Create(SaveDialog.FileName, fmCreate);
        try
          BFH.OriginalName:= ExtractFileName(OpenDialog.FileName);
          BFH.OriginalSize:= PStream.Size;
          BFH.OriginalDate:= FileAge(OpenDialog.FileName);
          BFH.EncryptStream(PStream, CStream);
        finally
          CStream.Free;
        end;
      end;
    finally
      PStream.Free;
    end;
  end;
end;

procedure TMainForm.SDecButtonClick(Sender: TObject);
var
  PStream,
  CStream: TFileStream;
begin
  OpenDialog.Filter:= 'BFH|*.BFH';
  if OpenDialog.Execute then
  begin
    CStream:= TFileStream.Create(OpenDialog.FileName, fmOpenRead);
    try
      if BFH.CheckBFHStream(CStream) then
      begin
        SaveDialog.Filter:= '*.*|*.*';
        SaveDialog.DefaultExt:= '';
        SaveDialog.InitialDir:= ExtractFilePath(OpenDialog.FileName);
        SaveDialog.FileName:= BFH.OriginalName;
        if SaveDialog.Execute then
        begin
          PStream:= TFileStream.Create(SaveDialog.FileName, fmCreate);
          try
            BFH.DecryptStream(CStream, PStream);
          finally
            PStream.Free;
          end;
        end;
      end;
    finally
      CStream.Free;
    end;
  end;
end;

end.
