unit CRC;

interface

function UpdCRC_8(cp: Byte; crc: Byte): Byte;
function GetCRC_8(Data: Pointer; DataLength: Integer): Byte;
function UpdCRC_16(cp: Byte; crc: Word): Word;
function GetCRC_16(Data: Pointer; DataLength: Integer): Word;
function UpdCRC_CCITT(cp: Byte; crc: Word): Word;
function GetCRC_CCITT(Data: Pointer; DataLength: Integer): Word;
function UpdCRC_32(cp: Byte; crc: LongInt): LongInt;
function GetCRC_32(Data: Pointer; DataLength: Integer): LongInt;


implementation

{*** CRC-8 (8,5,4,0) **********************************************************}

{ Initialise the variable to $00 before running the crc routine.}
function UpdCRC_8(cp: Byte; crc: Byte): Byte;
const
  crc_tab: array[0..255] of Byte = (
    $00, $5e, $bc, $e2, $61, $3f, $dd, $83,
    $c2, $9c, $7e, $20, $a3, $fd, $1f, $41,
    $9d, $c3, $21, $7f, $fc, $a2, $40, $1e,
    $5f, $01, $e3, $bd, $3e, $60, $82, $dc,
    $23, $7d, $9f, $c1, $42, $1c, $fe, $a0,
    $e1, $bf, $5d, $03, $80, $de, $3c, $62,
    $be, $e0, $02, $5c, $df, $81, $63, $3d,
    $7c, $22, $c0, $9e, $1d, $43, $a1, $ff,
    $46, $18, $fa, $a4, $27, $79, $9b, $c5,
    $84, $da, $38, $66, $e5, $bb, $59, $07,
    $DB, $85, $67, $39, $ba, $e4, $06, $58,
    $19, $47, $a5, $fb, $78, $26, $c4, $9a,
    $65, $3b, $d9, $87, $04, $5a, $b8, $e6,
    $a7, $f9, $1b, $45, $c6, $98, $7a, $24,
    $f8, $a6, $44, $1a, $99, $c7, $25, $7b,
    $3a, $64, $86, $d8, $5b, $05, $e7, $b9,
    $8c, $d2, $30, $6e, $ed, $b3, $51, $0f,
    $4e, $10, $f2, $ac, $2f, $71, $93, $cd,
    $11, $4f, $ad, $f3, $70, $2e, $cc, $92,
    $d3, $8d, $6f, $31, $b2, $ec, $0e, $50,
    $af, $f1, $13, $4d, $ce, $90, $72, $2c,
    $6d, $33, $d1, $8f, $0c, $52, $b0, $ee,
    $32, $6c, $8e, $d0, $53, $0d, $ef, $b1,
    $f0, $ae, $4c, $12, $91, $cf, $2d, $73,
    $ca, $94, $76, $28, $ab, $f5, $17, $49,
    $08, $56, $b4, $ea, $69, $37, $d5, $8b,
    $57, $09, $eb, $b5, $36, $68, $8a, $d4,
    $95, $cb, $29, $77, $f4, $aa, $48, $16,
    $e9, $b7, $55, $0b, $88, $d6, $34, $6a,
    $2b, $75, $97, $c9, $4a, $14, $f6, $a8,
    $74, $2a, $c8, $96, $15, $4b, $a9, $f7,
    $b6, $e8, $0a, $54, $d7, $89, $6b, $35
  );

begin
  Result:= crc_tab[crc XOR cp];
end;

function GetCRC_8(Data: Pointer; DataLength: Integer): Byte;
type
  TByteArray = Array[1..MaxInt] of Byte;
var
  i: Integer;
begin
  Result:= $00;
  for i:= 1 to DataLength do Result:= UpdCRC_8(TByteArray(Data^)[i], Result);
end;

{*** CRC-16 (16,15,2,0) *******************************************************}

{ Initialise the variable to $0000 before running the crc routine.}
function UpdCRC_16(cp: Byte; crc: Word): Word;
const
  crc_tab: array[0..255] of Word = (
    $0000, $c0c1, $c181, $0140, $c301, $03c0, $0280, $c241,
    $c601, $06c0, $0780, $c741, $0500, $c5c1, $c481, $0440,
    $cc01, $0cc0, $0d80, $cd41, $0f00, $cfc1, $ce81, $0e40,
    $0a00, $cac1, $cb81, $0b40, $c901, $09c0, $0880, $c841,
    $d801, $18c0, $1980, $d941, $1b00, $dbc1, $da81, $1a40,
    $1e00, $dec1, $df81, $1f40, $dd01, $1dc0, $1c80, $dc41,
    $1400, $d4c1, $d581, $1540, $d701, $17c0, $1680, $d641,
    $d201, $12c0, $1380, $d341, $1100, $d1c1, $d081, $1040,
    $f001, $30c0, $3180, $f141, $3300, $f3c1, $f281, $3240,
    $3600, $f6c1, $f781, $3740, $f501, $35c0, $3480, $f441,
    $3c00, $fcc1, $fd81, $3d40, $ff01, $3fc0, $3e80, $fe41,
    $fa01, $3ac0, $3b80, $fb41, $3900, $f9c1, $f881, $3840,
    $2800, $e8c1, $e981, $2940, $eb01, $2bc0, $2a80, $ea41,
    $ee01, $2ec0, $2f80, $ef41, $2d00, $edc1, $ec81, $2c40,
    $e401, $24c0, $2580, $e541, $2700, $e7c1, $e681, $2640,
    $2200, $e2c1, $e381, $2340, $e101, $21c0, $2080, $e041,
    $a001, $60c0, $6180, $a141, $6300, $a3c1, $a281, $6240,
    $6600, $a6c1, $a781, $6740, $a501, $65c0, $6480, $a441,
    $6c00, $acc1, $ad81, $6d40, $af01, $6fc0, $6e80, $ae41,
    $aa01, $6ac0, $6b80, $ab41, $6900, $a9c1, $a881, $6840,
    $7800, $b8c1, $b981, $7940, $bb01, $7bc0, $7a80, $ba41,
    $be01, $7ec0, $7f80, $bf41, $7d00, $bdc1, $bc81, $7c40,
    $b401, $74c0, $7580, $b541, $7700, $b7c1, $b681, $7640,
    $7200, $b2c1, $b381, $7340, $b101, $71c0, $7080, $b041,
    $5000, $90c1, $9181, $5140, $9301, $53c0, $5280, $9241,
    $9601, $56c0, $5780, $9741, $5500, $95c1, $9481, $5440,
    $9c01, $5cc0, $5d80, $9d41, $5f00, $9fc1, $9e81, $5e40,
    $5a00, $9ac1, $9b81, $5b40, $9901, $59c0, $5880, $9841,
    $8801, $48c0, $4980, $8941, $4b00, $8bc1, $8a81, $4a40,
    $4e00, $8ec1, $8f81, $4f40, $8d01, $4dc0, $4c80, $8c41,
    $4400, $84c1, $8581, $4540, $8701, $47c0, $4680, $8641,
    $8201, $42c0, $4380, $8341, $4100, $81c1, $8081, $4040
  );

begin
  Result:= crc_tab[Byte(crc) XOR cp] XOR (crc SHR 8);
end;

function GetCRC_16(Data: Pointer; DataLength: Integer) : WORD;
type
  TByteArray = Array[1..MaxInt] of Byte;
var
  i: Integer;
begin
  Result:= $0000;
  for i:= 1 to DataLength do Result:= UpdCRC_16(TByteArray(Data^)[i], Result);
end;

{*** CRC-16_CCITT (16,12,5,0) *******************************************************}

{ Initialise the variable to $FFFF before running the crc routine.}
function UpdCRC_CCITT(cp: Byte; crc: Word): Word;
const
  crc_tab: array[0..255] of Word = (
    $0000, $1021, $2042, $3063, $4084, $50a5, $60c6, $70e7,
    $8108, $9129, $a14a, $b16b, $c18c, $d1ad, $e1ce, $f1ef,
    $1231, $0210, $3273, $2252, $52b5, $4294, $72f7, $62d6,
    $9339, $8318, $b37b, $a35a, $d3bd, $c39c, $f3ff, $e3de,
    $2462, $3443, $0420, $1401, $64e6, $74c7, $44a4, $5485,
    $a56a, $b54b, $8528, $9509, $e5ee, $f5cf, $c5ac, $d58d,
    $3653, $2672, $1611, $0630, $76d7, $66f6, $5695, $46b4,
    $b75b, $a77a, $9719, $8738, $f7df, $e7fe, $d79d, $c7bc,
    $48c4, $58e5, $6886, $78a7, $0840, $1861, $2802, $3823,
    $c9cc, $d9ed, $e98e, $f9af, $8948, $9969, $a90a, $b92b,
    $5af5, $4ad4, $7ab7, $6a96, $1a71, $0a50, $3a33, $2a12,
    $dbfd, $cbdc, $fbbf, $eb9e, $9b79, $8b58, $bb3b, $ab1a,
    $6ca6, $7c87, $4ce4, $5cc5, $2c22, $3c03, $0c60, $1c41,
    $edae, $fd8f, $cdec, $ddcd, $ad2a, $bd0b, $8d68, $9d49,
    $7e97, $6eb6, $5ed5, $4ef4, $3e13, $2e32, $1e51, $0e70,
    $ff9f, $efbe, $dfdd, $cffc, $bf1b, $af3a, $9f59, $8f78,
    $9188, $81a9, $b1ca, $a1eb, $d10c, $c12d, $f14e, $e16f,
    $1080, $00a1, $30c2, $20e3, $5004, $4025, $7046, $6067,
    $83b9, $9398, $a3fb, $b3da, $c33d, $d31c, $e37f, $f35e,
    $02b1, $1290, $22f3, $32d2, $4235, $5214, $6277, $7256,
    $b5ea, $a5cb, $95a8, $8589, $f56e, $e54f, $d52c, $c50d,
    $34e2, $24c3, $14a0, $0481, $7466, $6447, $5424, $4405,
    $a7db, $b7fa, $8799, $97b8, $e75f, $f77e, $c71d, $d73c,
    $26d3, $36f2, $0691, $16b0, $6657, $7676, $4615, $5634,
    $d94c, $c96d, $f90e, $e92f, $99c8, $89e9, $b98a, $a9ab,
    $5844, $4865, $7806, $6827, $18c0, $08e1, $3882, $28a3,
    $cb7d, $db5c, $eb3f, $fb1e, $8bf9, $9bd8, $abbb, $bb9a,
    $4a75, $5a54, $6a37, $7a16, $0af1, $1ad0, $2ab3, $3a92,
    $fd2e, $ed0f, $dd6c, $cd4d, $bdaa, $ad8b, $9de8, $8dc9,
    $7c26, $6c07, $5c64, $4c45, $3ca2, $2c83, $1ce0, $0cc1,
    $ef1f, $ff3e, $cf5d, $df7c, $af9b, $bfba, $8fd9, $9ff8,
    $6e17, $7e36, $4e55, $5e74, $2e93, $3eb2, $0ed1, $1ef0
  );

begin
  Result:= crc_tab[Byte(crc SHR 8) XOR cp] XOR Word(crc SHL 8);
end;

function GetCRC_CCITT(Data: Pointer; DataLength: Integer) : WORD;
type
  TByteArray = Array[1..MaxInt] of Byte;
var
  i: Integer;
begin
  Result:= $FFFF;
  for i:= 1 to DataLength do Result:= UpdCRC_CCITT(TByteArray(Data^)[i], Result);
end;

{*** CRC-32 (32,26,23,22,16,12,11,10,8,7,5,4,2,1,0) ***************************}

{ Initialise the variable to $FFFFFFFF before running the crc routine.}
function UpdCRC_32(cp: Byte; crc: LongInt) : LongInt;
const
  crc_tab: array[0..255] of LongInt = (
    $00000000, $77073096, $ee0e612c, $990951ba, $076dc419, $706af48f, $e963a535, $9e6495a3,
    $0edb8832, $79dcb8a4, $e0d5e91e, $97d2d988, $09b64c2b, $7eb17cbd, $e7b82d07, $90bf1d91,
    $1db71064, $6ab020f2, $f3b97148, $84be41de, $1adad47d, $6ddde4eb, $f4d4b551, $83d385c7,
    $136c9856, $646ba8c0, $fd62f97a, $8a65c9ec, $14015c4f, $63066cd9, $fa0f3d63, $8d080df5,
    $3b6e20c8, $4c69105e, $d56041e4, $a2677172, $3c03e4d1, $4b04d447, $d20d85fd, $a50ab56b,
    $35b5a8fa, $42b2986c, $dbbbc9d6, $acbcf940, $32d86ce3, $45df5c75, $dcd60dcf, $abd13d59,
    $26d930ac, $51de003a, $c8d75180, $bfd06116, $21b4f4b5, $56b3c423, $cfba9599, $b8bda50f,
    $2802b89e, $5f058808, $c60cd9b2, $b10be924, $2f6f7c87, $58684c11, $c1611dab, $b6662d3d,
    $76dc4190, $01db7106, $98d220bc, $efd5102a, $71b18589, $06b6b51f, $9fbfe4a5, $e8b8d433,
    $7807c9a2, $0f00f934, $9609a88e, $e10e9818, $7f6a0dbb, $086d3d2d, $91646c97, $e6635c01,
    $6b6b51f4, $1c6c6162, $856530d8, $f262004e, $6c0695ed, $1b01a57b, $8208f4c1, $f50fc457,
    $65b0d9c6, $12b7e950, $8bbeb8ea, $fcb9887c, $62dd1ddf, $15da2d49, $8cd37cf3, $fbd44c65,
    $4db26158, $3ab551ce, $a3bc0074, $d4bb30e2, $4adfa541, $3dd895d7, $a4d1c46d, $d3d6f4fb,
    $4369e96a, $346ed9fc, $ad678846, $da60b8d0, $44042d73, $33031de5, $aa0a4c5f, $dd0d7cc9,
    $5005713c, $270241aa, $be0b1010, $c90c2086, $5768b525, $206f85b3, $b966d409, $ce61e49f,
    $5edef90e, $29d9c998, $b0d09822, $c7d7a8b4, $59b33d17, $2eb40d81, $b7bd5c3b, $c0ba6cad,
    $edb88320, $9abfb3b6, $03b6e20c, $74b1d29a, $ead54739, $9dd277af, $04db2615, $73dc1683,
    $e3630b12, $94643b84, $0d6d6a3e, $7a6a5aa8, $e40ecf0b, $9309ff9d, $0a00ae27, $7d079eb1,
    $f00f9344, $8708a3d2, $1e01f268, $6906c2fe, $f762575d, $806567cb, $196c3671, $6e6b06e7,
    $fed41b76, $89d32be0, $10da7a5a, $67dd4acc, $f9b9df6f, $8ebeeff9, $17b7be43, $60b08ed5,
    $d6d6a3e8, $a1d1937e, $38d8c2c4, $4fdff252, $d1bb67f1, $a6bc5767, $3fb506dd, $48b2364b,
    $d80d2bda, $af0a1b4c, $36034af6, $41047a60, $df60efc3, $a867df55, $316e8eef, $4669be79,
    $cb61b38c, $bc66831a, $256fd2a0, $5268e236, $cc0c7795, $bb0b4703, $220216b9, $5505262f,
    $c5ba3bbe, $b2bd0b28, $2bb45a92, $5cb36a04, $c2d7ffa7, $b5d0cf31, $2cd99e8b, $5bdeae1d,
    $9b64c2b0, $ec63f226, $756aa39c, $026d930a, $9c0906a9, $eb0e363f, $72076785, $05005713,
    $95bf4a82, $e2b87a14, $7bb12bae, $0cb61b38, $92d28e9b, $e5d5be0d, $7cdcefb7, $0bdbdf21,
    $86d3d2d4, $f1d4e242, $68ddb3f8, $1fda836e, $81be16cd, $f6b9265b, $6fb077e1, $18b74777,
    $88085ae6, $ff0f6a70, $66063bca, $11010b5c, $8f659eff, $f862ae69, $616bffd3, $166ccf45,
    $a00ae278, $d70dd2ee, $4e048354, $3903b3c2, $a7672661, $d06016f7, $4969474d, $3e6e77db,
    $aed16a4a, $d9d65adc, $40df0b66, $37d83bf0, $a9bcae53, $debb9ec5, $47b2cf7f, $30b5ffe9,
    $bdbdf21c, $cabac28a, $53b39330, $24b4a3a6, $bad03605, $cdd70693, $54de5729, $23d967bf,
    $b3667a2e, $c4614ab8, $5d681b02, $2a6f2b94, $b40bbe37, $c30c8ea1, $5a05df1b, $2d02ef8d
  );

begin
  Result:= crc_tab[Byte(crc) XOR cp] XOR (crc SHR 8);
end;

function GetCRC_32(Data: Pointer; DataLength: Integer) : LongInt;
type
  TByteArray = Array[1..MaxInt] of Byte;
var
  i: Integer;
begin
  Result:= $FFFFFFFF;
  for i:= 1 to DataLength do Result:= UpdCRC_32(TByteArray(Data^)[i], Result);
  Result:= Result XOR $FFFFFFFF;
end;

end.

{
CRC-16 (16,15,2,0)
    $0000, $8005, $800f, $000a, $801b, $001e, $0014, $8011,
    $8033, $0036, $003c, $8039, $0028, $802d, $8027, $0022,
    $8063, $0066, $006c, $8069, $0078, $807d, $8077, $0072,
    $0050, $8055, $805f, $005a, $804b, $004e, $0044, $8041,
    $80c3, $00c6, $00cc, $80c9, $00d8, $80dd, $80d7, $00d2,
    $00f0, $80f5, $80ff, $00fa, $80eb, $00ee, $00e4, $80e1,
    $00a0, $80a5, $80af, $00aa, $80bb, $00be, $00b4, $80b1,
    $8093, $0096, $009c, $8099, $0088, $808d, $8087, $0082,
    $8183, $0186, $018c, $8189, $0198, $819d, $8197, $0192,
    $01b0, $81b5, $81bf, $01ba, $81ab, $01ae, $01a4, $81a1,
    $01e0, $81e5, $81ef, $01ea, $81fb, $01fe, $01f4, $81f1,
    $81d3, $01d6, $01dc, $81d9, $01c8, $81cd, $81c7, $01c2,
    $0140, $8145, $814f, $014a, $815b, $015e, $0154, $8151,
    $8173, $0176, $017c, $8179, $0168, $816d, $8167, $0162,
    $8123, $0126, $012c, $8129, $0138, $813d, $8137, $0132,
    $0110, $8115, $811f, $011a, $810b, $010e, $0104, $8101,
    $8303, $0306, $030c, $8309, $0318, $831d, $8317, $0312,
    $0330, $8335, $833f, $033a, $832b, $032e, $0324, $8321,
    $0360, $8365, $836f, $036a, $837b, $037e, $0374, $8371,
    $8353, $0356, $035c, $8359, $0348, $834d, $8347, $0342,
    $03c0, $83c5, $83cf, $03ca, $83db, $03de, $03d4, $83d1,
    $83f3, $03f6, $03fc, $83f9, $03e8, $83ed, $83e7, $03e2,
    $83a3, $03a6, $03ac, $83a9, $03b8, $83bd, $83b7, $03b2,
    $0390, $8395, $839f, $039a, $838b, $038e, $0384, $8381,
    $0280, $8285, $828f, $028a, $829b, $029e, $0294, $8291,
    $82b3, $02b6, $02bc, $82b9, $02a8, $82ad, $82a7, $02a2,
    $82e3, $02e6, $02ec, $82e9, $02f8, $82fd, $82f7, $02f2,
    $02d0, $82d5, $82df, $02da, $82cb, $02ce, $02c4, $82c1,
    $8243, $0246, $024c, $8249, $0258, $825d, $8257, $0252,
    $0270, $8275, $827f, $027a, $826b, $026e, $0264, $8261,
    $0220, $8225, $822f, $022a, $823b, $023e, $0234, $8231,
    $8213, $0216, $021c, $8219, $0208, $820d, $8207, $0202

Rev CRC-16 (16,15,2,0)
    $0000, $c0c1, $c181, $0140, $c301, $03c0, $0280, $c241,
    $c601, $06c0, $0780, $c741, $0500, $c5c1, $c481, $0440,
    $cc01, $0cc0, $0d80, $cd41, $0f00, $cfc1, $ce81, $0e40,
    $0a00, $cac1, $cb81, $0b40, $c901, $09c0, $0880, $c841,
    $d801, $18c0, $1980, $d941, $1b00, $dbc1, $da81, $1a40,
    $1e00, $dec1, $df81, $1f40, $dd01, $1dc0, $1c80, $dc41,
    $1400, $d4c1, $d581, $1540, $d701, $17c0, $1680, $d641,
    $d201, $12c0, $1380, $d341, $1100, $d1c1, $d081, $1040,
    $f001, $30c0, $3180, $f141, $3300, $f3c1, $f281, $3240,
    $3600, $f6c1, $f781, $3740, $f501, $35c0, $3480, $f441,
    $3c00, $fcc1, $fd81, $3d40, $ff01, $3fc0, $3e80, $fe41,
    $fa01, $3ac0, $3b80, $fb41, $3900, $f9c1, $f881, $3840,
    $2800, $e8c1, $e981, $2940, $eb01, $2bc0, $2a80, $ea41,
    $ee01, $2ec0, $2f80, $ef41, $2d00, $edc1, $ec81, $2c40,
    $e401, $24c0, $2580, $e541, $2700, $e7c1, $e681, $2640,
    $2200, $e2c1, $e381, $2340, $e101, $21c0, $2080, $e041,
    $a001, $60c0, $6180, $a141, $6300, $a3c1, $a281, $6240,
    $6600, $a6c1, $a781, $6740, $a501, $65c0, $6480, $a441,
    $6c00, $acc1, $ad81, $6d40, $af01, $6fc0, $6e80, $ae41,
    $aa01, $6ac0, $6b80, $ab41, $6900, $a9c1, $a881, $6840,
    $7800, $b8c1, $b981, $7940, $bb01, $7bc0, $7a80, $ba41,
    $be01, $7ec0, $7f80, $bf41, $7d00, $bdc1, $bc81, $7c40,
    $b401, $74c0, $7580, $b541, $7700, $b7c1, $b681, $7640,
    $7200, $b2c1, $b381, $7340, $b101, $71c0, $7080, $b041,
    $5000, $90c1, $9181, $5140, $9301, $53c0, $5280, $9241,
    $9601, $56c0, $5780, $9741, $5500, $95c1, $9481, $5440,
    $9c01, $5cc0, $5d80, $9d41, $5f00, $9fc1, $9e81, $5e40,
    $5a00, $9ac1, $9b81, $5b40, $9901, $59c0, $5880, $9841,
    $8801, $48c0, $4980, $8941, $4b00, $8bc1, $8a81, $4a40,
    $4e00, $8ec1, $8f81, $4f40, $8d01, $4dc0, $4c80, $8c41,
    $4400, $84c1, $8581, $4540, $8701, $47c0, $4680, $8641,
    $8201, $42c0, $4380, $8341, $4100, $81c1, $8081, $4040

CRC-CCITT (16,12,5,0)
    $0000, $1021, $2042, $3063, $4084, $50a5, $60c6, $70e7,
    $8108, $9129, $a14a, $b16b, $c18c, $d1ad, $e1ce, $f1ef,
    $1231, $0210, $3273, $2252, $52b5, $4294, $72f7, $62d6,
    $9339, $8318, $b37b, $a35a, $d3bd, $c39c, $f3ff, $e3de,
    $2462, $3443, $0420, $1401, $64e6, $74c7, $44a4, $5485,
    $a56a, $b54b, $8528, $9509, $e5ee, $f5cf, $c5ac, $d58d,
    $3653, $2672, $1611, $0630, $76d7, $66f6, $5695, $46b4,
    $b75b, $a77a, $9719, $8738, $f7df, $e7fe, $d79d, $c7bc,
    $48c4, $58e5, $6886, $78a7, $0840, $1861, $2802, $3823,
    $c9cc, $d9ed, $e98e, $f9af, $8948, $9969, $a90a, $b92b,
    $5af5, $4ad4, $7ab7, $6a96, $1a71, $0a50, $3a33, $2a12,
    $dbfd, $cbdc, $fbbf, $eb9e, $9b79, $8b58, $bb3b, $ab1a,
    $6ca6, $7c87, $4ce4, $5cc5, $2c22, $3c03, $0c60, $1c41,
    $edae, $fd8f, $cdec, $ddcd, $ad2a, $bd0b, $8d68, $9d49,
    $7e97, $6eb6, $5ed5, $4ef4, $3e13, $2e32, $1e51, $0e70,
    $ff9f, $efbe, $dfdd, $cffc, $bf1b, $af3a, $9f59, $8f78,
    $9188, $81a9, $b1ca, $a1eb, $d10c, $c12d, $f14e, $e16f,
    $1080, $00a1, $30c2, $20e3, $5004, $4025, $7046, $6067,
    $83b9, $9398, $a3fb, $b3da, $c33d, $d31c, $e37f, $f35e,
    $02b1, $1290, $22f3, $32d2, $4235, $5214, $6277, $7256,
    $b5ea, $a5cb, $95a8, $8589, $f56e, $e54f, $d52c, $c50d,
    $34e2, $24c3, $14a0, $0481, $7466, $6447, $5424, $4405,
    $a7db, $b7fa, $8799, $97b8, $e75f, $f77e, $c71d, $d73c,
    $26d3, $36f2, $0691, $16b0, $6657, $7676, $4615, $5634,
    $d94c, $c96d, $f90e, $e92f, $99c8, $89e9, $b98a, $a9ab,
    $5844, $4865, $7806, $6827, $18c0, $08e1, $3882, $28a3,
    $cb7d, $db5c, $eb3f, $fb1e, $8bf9, $9bd8, $abbb, $bb9a,
    $4a75, $5a54, $6a37, $7a16, $0af1, $1ad0, $2ab3, $3a92,
    $fd2e, $ed0f, $dd6c, $cd4d, $bdaa, $ad8b, $9de8, $8dc9,
    $7c26, $6c07, $5c64, $4c45, $3ca2, $2c83, $1ce0, $0cc1,
    $ef1f, $ff3e, $cf5d, $df7c, $af9b, $bfba, $8fd9, $9ff8,
    $6e17, $7e36, $4e55, $5e74, $2e93, $3eb2, $0ed1, $1ef0

Rev CRC-CCITT (16,12,5,0)
    $0000, $1189, $2312, $329b, $4624, $57ad, $6536, $74bf,
    $8c48, $9dc1, $af5a, $bed3, $ca6c, $dbe5, $e97e, $f8f7,
    $1081, $0108, $3393, $221a, $56a5, $472c, $75b7, $643e,
    $9cc9, $8d40, $bfdb, $ae52, $daed, $cb64, $f9ff, $e876,
    $2102, $308b, $0210, $1399, $6726, $76af, $4434, $55bd,
    $ad4a, $bcc3, $8e58, $9fd1, $eb6e, $fae7, $c87c, $d9f5,
    $3183, $200a, $1291, $0318, $77a7, $662e, $54b5, $453c,
    $bdcb, $ac42, $9ed9, $8f50, $fbef, $ea66, $d8fd, $c974,
    $4204, $538d, $6116, $709f, $0420, $15a9, $2732, $36bb,
    $ce4c, $dfc5, $ed5e, $fcd7, $8868, $99e1, $ab7a, $baf3,
    $5285, $430c, $7197, $601e, $14a1, $0528, $37b3, $263a,
    $decd, $cf44, $fddf, $ec56, $98e9, $8960, $bbfb, $aa72,
    $6306, $728f, $4014, $519d, $2522, $34ab, $0630, $17b9,
    $ef4e, $fec7, $cc5c, $ddd5, $a96a, $b8e3, $8a78, $9bf1,
    $7387, $620e, $5095, $411c, $35a3, $242a, $16b1, $0738,
    $ffcf, $ee46, $dcdd, $cd54, $b9eb, $a862, $9af9, $8b70,
    $8408, $9581, $a71a, $b693, $c22c, $d3a5, $e13e, $f0b7,
    $0840, $19c9, $2b52, $3adb, $4e64, $5fed, $6d76, $7cff,
    $9489, $8500, $b79b, $a612, $d2ad, $c324, $f1bf, $e036,
    $18c1, $0948, $3bd3, $2a5a, $5ee5, $4f6c, $7df7, $6c7e,
    $a50a, $b483, $8618, $9791, $e32e, $f2a7, $c03c, $d1b5,
    $2942, $38cb, $0a50, $1bd9, $6f66, $7eef, $4c74, $5dfd,
    $b58b, $a402, $9699, $8710, $f3af, $e226, $d0bd, $c134,
    $39c3, $284a, $1ad1, $0b58, $7fe7, $6e6e, $5cf5, $4d7c,
    $c60c, $d785, $e51e, $f497, $8028, $91a1, $a33a, $b2b3,
    $4a44, $5bcd, $6956, $78df, $0c60, $1de9, $2f72, $3efb,
    $d68d, $c704, $f59f, $e416, $90a9, $8120, $b3bb, $a232,
    $5ac5, $4b4c, $79d7, $685e, $1ce1, $0d68, $3ff3, $2e7a,
    $e70e, $f687, $c41c, $d595, $a12a, $b0a3, $8238, $93b1,
    $6b46, $7acf, $4854, $59dd, $2d62, $3ceb, $0e70, $1ff9,
    $f78f, $e606, $d49d, $c514, $b1ab, $a022, $92b9, $8330,
    $7bc7, $6a4e, $58d5, $495c, $3de3, $2c6a, $1ef1, $0f78
}
